// package globalExamples;

import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.FundamentalMetadataProvider;
import oracle.olapi.data.source.FundamentalMetadataObject;

import oracle.olapi.metadata.mdm.MdmCustomObjectFactory;
import oracle.olapi.metadata.mdm.MdmAttribute;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;

import oracle.olapi.metadata.mtm.MtmCustomObjectFactory;
import oracle.olapi.metadata.mtm.MtmValueExpression;

/**
 * This program creates the custom MdmAttribute for the Product dimension
 * and relates colors to some of the Product dimension members.
 * The program returns an MdmAttribute.
 *
 * @author Oracle Corporation
 */
public class CreateColorAttribute
{
  public MdmAttribute getAttribute(Context10g context, DataProvider dp)
  {
    // Get the MdmPrimaryDimension for the Global schema dimension of product
    // values.
    MdmPrimaryDimension mdmProdDim =
                             context.getMdmPrimaryDimensionByName("PRODUCT");

    // Get the default hierarchy for the PRODUCT dimension.
    MdmLevelHierarchy mdmProdHier = (MdmLevelHierarchy)
                                     mdmProdDim.getDefaultHierarchy();

    // Get the Source for the hierarchy.
    Source prodHier = mdmProdHier.getSource();

    // Get the short value description attribute for the primary dimension.
    MdmAttribute mdmProdShortDescr =
                               mdmProdDim.getShortValueDescriptionAttribute();
    Source prodShortDescr = mdmProdShortDescr.getSource();

    // Get the FundamentalMetadataProvider and the String data type object.
    FundamentalMetadataProvider fdp =
                                   context.dp.getFundamentalMetadataProvider();
    FundamentalMetadataObject fmoSstringDT = fdp.getStringDataType();

    // Create a String for a SQL expression that assigns color values to
    // products.
    String sqlExp = "(case when item_id in " +
                    "(13, 14, 15, 19, 22, 24, 27, 33, 34, 35, 46, 48) " +
                    "then 'Black' " +
                    "when item_id in (16, 17, 18, 20, 21, 23, 32, 36, 37, 47)" +
                    " then 'Beige' " +
                    "when item_id in (25, 26, 30, 31) then 'Green' " +
                    "when item_id in (28) then 'Red' " +
                    "when item_id in (29) then 'Orange' " +
                    "when item_id in (40, 41, 42, 43, 44, 45) then 'Blue' " +
                    "else null end)";

    // Get the MtmCustomObjectFactory and create a custom expression with the
    // SQL statement.
    MtmCustomObjectFactory mtmCustObjFactory =
                                       context.mp.getMtmCustomObjectFactory();
    MtmValueExpression expression = (MtmValueExpression)
       mtmCustObjFactory.createCustomExpression(sqlExp, fmoSstringDT);

    // Get the MdmCustomObjectFactory and create a custom attribute with the
    // custom expression.
    MdmCustomObjectFactory mdmCustObjFactory =
                                        context.mp.getMdmCustomObjectFactory();
    // Create a custom MdmAttribute that relates color values to some
    // members of the Product dimension.
    MdmAttribute mdmProdColorAttr =
          mdmCustObjFactory.createStringAttribute("ProductColor",
                                                   mdmProdDim,
                                                   expression);
    // Return the color MdmAttribute.
    return mdmProdColorAttr;

  }

}

